#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2012, Ramin & Irmgard Sabet'
__docformat__ = 'restructuredtext en'

if False:
    # This is here to keep my python error checker from complaining about
    # the builtin functions that will be defined by the plugin loading system
    # You do not need this code in your plugins
    get_icons = get_resources = None

from PyQt4.Qt import QDialog, QVBoxLayout, QHBoxLayout, QPushButton, QCheckBox, QTimer
from PyQt4.Qt import QMessageBox, QLabel, QTextEdit, QTableWidget,QTableWidgetItem, QLineEdit 
#from PyQt4.QtCore import Qt
#from PyQt4.QtGui import QCursor

from calibre.gui2.complete import MultiCompleteComboBox, MultiCompleteLineEdit



from calibre_plugins.merge_tags.config import prefs
import cStringIO


class DemoDialog(QDialog):

    def __init__(self, gui, icon, do_user_config):
        QDialog.__init__(self, gui)
        self.gui = gui
        self.do_user_config = do_user_config

        # The current database shown in the GUI
        # db is an instance of the class LibraryDatabase2 from database.py
        # This class has many, many methods that allow you to do a lot of
        # things.
        self.db = gui.current_db

        self.l = QVBoxLayout()
        self.setLayout(self.l)

        self.lTop = QHBoxLayout()

        self.label = QLabel("Merge books with identical title and author(s)")
        self.lTop.addWidget(self.label)

        self.btnAbout = QPushButton('About', self)
        self.btnAbout.clicked.connect(self.about)
        self.lTop.addWidget(self.btnAbout)
        self.l.addLayout(self.lTop)


        l = QHBoxLayout()
        lbl=QLabel('Filter')
        l.addWidget(lbl)
        self.txtFilter = QLineEdit()
        self.txtFilter.textChanged.connect(self.OnFilterTags)
        l.addWidget(self.txtFilter)
        self.l.addLayout(l)
        
        self.arTags = self.db.get_tags_with_ids()
        self.tbl = QTableWidget()
        self.tbl.setColumnCount(2)
        

        self.l.addWidget(self.tbl)
        
        self.setWindowTitle('Merge Tags')
        self.setWindowIcon(icon)

        self.resize(self.sizeHint())
        #self.cursor = QCursor(Qt.WaitCursor) 
        QTimer.singleShot(0, self.delayedInit)

    def delayedInit(self):
        self.populateTable()
        
    def populateTable(self, strFilter=''):
        if strFilter:
            strFilterLower = str(strFilter).lower()
            self.FilteredTags = [i for i in self.arTags if strFilterLower in i[1].lower()]
        else:
            self.FilteredTags = self.arTags
        self.tbl.setRowCount(len(self.FilteredTags))
        self.tbl.setHorizontalHeaderLabels(('check','Tag'))
        for row,tag in enumerate(self.FilteredTags):
            tid,tag=tag
            #print (tag)
            newitem = QTableWidgetItem(tag)
            self.tbl.setItem(row, 1, newitem)
            self.tbl.setCellWidget(row,0,QCheckBox())
        self.tbl.show()


    def OnFilterTags(self):
        print(self.txtFilter.text())
        if len(self.txtFilter.text())>2:
            self.populateTable(self.txtFilter.text())
        
    def about(self):
        # Get the about text from a file inside the plugin zip file
        # The get_resources function is a builtin function defined for all your
        # plugin code. It loads files from the plugin zip file. It returns
        # the bytes from the specified file.
        #
        # Note that if you are loading more than one file, for performance, you
        # should pass a list of names to get_resources. In this case,
        # get_resources will return a dictionary mapping names to bytes. Names that
        # are not found in the zip file will not be in the returned dictionary.
        text = get_resources('about.txt')
        QMessageBox.about(self, 'About the Merge Duplicates Plugin',
                text.decode('utf-8'))

    def cleanName(self, s):
        s = s.lower()
        if s.startswith('the'):
            s = s[3:]
        if s.startswith('a '):
            s = s[1:]
        for c in s:
            if not unicode.isalnum(c):
                s = s.replace(c, '')

        return s

    def OnCancel(self):
        self.bContinue = False

    def start_merge(self):
        # self.FIELD_MAP = {'id':0, 'title':1, 'authors':2, 'timestamp':3,
             # 'size':4, 'rating':5, 'tags':6, 'comments':7, 'series':8,
             # 'publisher':9, 'series_index':10, 'sort':11, 'author_sort':12,
             # 'formats':13, 'path':14, 'pubdate':15, 'uuid':16, 'cover':17,
             # 'au_map':18, 'last_modified':19, 'identifiers':20, 'languages':21}

        self.bContinue = True
        
        self.btnMerge.setEnabled(False)
        self.btnCancel.setEnabled(True)

        id_field = self.db.FIELD_MAP['id']
        title_field = self.db.FIELD_MAP['title']
        authors_field = self.db.FIELD_MAP['authors']

        self.matched_ids = set()
        all = {}
        num = 0
        self.bar.setValue(num)
        self.bar.setMaximum(self.db.data.count())
        self.txtLog.setPlainText("Analyzing Books ...")

        for record in self.db.data.iterall():
            id = record[id_field]
            title = record[title_field]
            authors = record[authors_field]
            if not title or not authors:
                continue
            if '|' in authors:
                ar = authors.split('|')
                key = self.cleanName(title) + self.cleanName(ar[1] + ar[0])
                #print(key)
                if key in all:
                    self.matched_ids.add((id, all[key]))
                else:
                    all[key] = id
            key = self.cleanName(title) + self.cleanName(authors)
            if key in all:
                self.matched_ids.add((id, all[key]))
            else:
                all[key] = id
            self.bar.setValue(num)
            num += 1

        self.lToSelect = []
        self.sum = len(self.matched_ids)
        self.bar.setValue(0)
        self.bar.setMaximum(self.sum)
        self.txtLog.append("Merging Books ...")

        self.do_merge()

    def do_merge(self):
        bOk = True
        if self.bContinue and len(self.matched_ids):
            s = self.matched_ids.pop()
            try:
                idx_src = s[0]
                idx_dst = s[1]
                mi_src = self.db.get_metadata(idx_src, index_is_id=True)
                mi_dst = self.db.get_metadata(idx_dst, index_is_id=True)
            except:
                print('skipping')
                self.txtLog.append('   Skipping')
                bOk = False

            num = self.sum - len(self.matched_ids)
            if bOk:
                self.txtLog.append("%d/%d" % (num, self.sum))
                self.txtLog.append(3 * " " + mi_src.title + "; " + ','.join(mi_src.authors))
                self.txtLog.append(3 * " " + mi_dst.title + "; " + ','.join(mi_dst.authors))
    
                print("%d/%d" % (num, self.sum))
                print (3 * " " + mi_src.title, mi_src.authors)
                print (3 * " " + mi_dst.title, mi_dst.authors)
    
                tags_src = set(mi_src.tags)
                for i in mi_dst.tags:
                    tags_src.add(i)
    
                if not mi_dst.comments:
                    mi_dst.comments = mi_src.comments
    
                try:
                    mi_dst.tags = tags_src
                    self.db.set_metadata(idx_dst, mi_dst)
    
                    for fmt in mi_src.formats:
                        print("moving " + fmt)
                        if self.checkTest.isChecked():
                            self.txtLog.append(3 * " " + "Would Move: " + fmt)
                            continue
                        self.txtLog.append(3 * " " + "Moving: " + fmt)
    
                        f = cStringIO.StringIO()
                        self.db.copy_format_to(idx_src, fmt, f, index_is_id=True)
                        f.seek(0)
                        self.db.add_format(idx_dst, fmt, f, index_is_id=True)
    
                    if not self.checkTest.isChecked():
                        self.db.delete_book(idx_src)
                    self.lToSelect.append(idx_dst)
                except:
                    print("Error")
                    self.txtLog.append("   Error !\n")

            self.bar.setValue(num)
            QTimer.singleShot(0, self.do_merge)
        else:
            self.btnMerge.setEnabled(True)
            self.btnCancel.setEnabled(False)

            # Mark the records with the matching ids
            self.db.set_marked_ids(self.lToSelect)

            # Tell the GUI to search for all marked records
            self.gui.search.setEditText('marked:true')
            self.gui.search.do_search()

            print (self.lToSelect)
            if not self.bContinue:
                self.txtLog.append("Canceled!")
            else:
                if self.checkTest.isChecked():
                    self.txtLog.append("DONE Testing!")
                else:
                    self.txtLog.append("DONE!")

    def view(self):
        most_recent = most_recent_id = None
        timestamp_idx = self.db.FIELD_MAP['timestamp']

        for record in self.db.data:
            # Iterate over all currently showing records
            timestamp = record[timestamp_idx]
            if most_recent is None or timestamp > most_recent:
                most_recent = timestamp
                most_recent_id = record[0]

        if most_recent_id is not None:
            # Get the row number of the id as shown in the GUI
            row_number = self.db.row(most_recent_id)
            # Get a reference to the View plugin
            view_plugin = self.gui.iactions['View']
            # Ask the view plugin to launch the viewer for row_number
            view_plugin._view_books([row_number])

    def config(self):
        self.do_user_config(parent=self)
        # Apply the changes
        ##self.label.setText(prefs['hello_world_msg'])
        return
